/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.r2dbc.dialect.ArrayColumns;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.LimitClause;
import org.springframework.data.r2dbc.mapping.R2dbcSimpleTypeHolder;

public interface Dialect {
    public BindMarkersFactory getBindMarkersFactory();

    default public Collection<? extends Class<?>> getSimpleTypes() {
        return Collections.emptySet();
    }

    default public SimpleTypeHolder getSimpleTypeHolder() {
        HashSet simpleTypes = new HashSet(this.getSimpleTypes());
        simpleTypes.addAll(R2dbcSimpleTypeHolder.R2DBC_SIMPLE_TYPES);
        return new SimpleTypeHolder(simpleTypes, true);
    }

    public LimitClause limit();

    default public ArrayColumns getArraySupport() {
        return ArrayColumns.Unsupported.INSTANCE;
    }
}

