/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.dialect;

import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.r2dbc.dialect.ArrayColumns;
import org.springframework.data.r2dbc.dialect.BindMarkersFactory;
import org.springframework.data.r2dbc.dialect.Dialect;
import org.springframework.data.r2dbc.dialect.LimitClause;

public class MySqlDialect
implements Dialect {
    private static final Set<Class<?>> SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(UUID.class, URL.class, URI.class, InetAddress.class));
    public static final MySqlDialect INSTANCE = new MySqlDialect();
    private static final BindMarkersFactory ANONYMOUS = BindMarkersFactory.anonymous("?");
    private static final LimitClause LIMIT_CLAUSE = new LimitClause(){

        @Override
        public String getClause(long limit, long offset) {
            return String.format("LIMIT %d,%d", limit, offset);
        }

        @Override
        public String getClause(long limit) {
            return "LIMIT " + limit;
        }

        @Override
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.END;
        }
    };

    @Override
    public BindMarkersFactory getBindMarkersFactory() {
        return ANONYMOUS;
    }

    @Override
    public Collection<? extends Class<?>> getSimpleTypes() {
        return SIMPLE_TYPES;
    }

    @Override
    public LimitClause limit() {
        return LIMIT_CLAUSE;
    }

    @Override
    public ArrayColumns getArraySupport() {
        return ArrayColumns.Unsupported.INSTANCE;
    }
}

