/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.mapping;

import java.util.Objects;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SettableValue {
    @Nullable
    private final Object value;
    private final Class<?> type;

    private SettableValue(@Nullable Object value, Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        this.value = value;
        this.type = type;
    }

    public static SettableValue from(Object value) {
        Assert.notNull((Object)value, (String)"Value must not be null");
        return new SettableValue(value, ClassUtils.getUserClass((Object)value));
    }

    public static SettableValue fromOrEmpty(@Nullable Object value, Class<?> type) {
        return value == null ? SettableValue.empty(type) : new SettableValue(value, ClassUtils.getUserClass((Object)value));
    }

    public static SettableValue empty(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null");
        return new SettableValue(null, type);
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SettableValue)) {
            return false;
        }
        SettableValue value1 = (SettableValue)o;
        return Objects.equals(this.value, value1.value) && Objects.equals(this.type, value1.type);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SettableValue");
        sb.append("[value=").append(this.value);
        sb.append(", type=").append(this.type);
        sb.append(']');
        return sb.toString();
    }
}

