/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Update {
    private static final Update EMPTY = new Update(Collections.emptyMap());
    private final Map<String, Object> columnsToUpdate;

    private Update(Map<String, Object> columnsToUpdate) {
        this.columnsToUpdate = columnsToUpdate;
    }

    public static Update update(String column, @Nullable Object value) {
        return EMPTY.set(column, value);
    }

    public Update set(String column, @Nullable Object value) {
        return this.addMultiFieldOperation(column, value);
    }

    public Map<String, Object> getAssignments() {
        return Collections.unmodifiableMap(this.columnsToUpdate);
    }

    private Update addMultiFieldOperation(String key, Object value) {
        Assert.hasText((String)key, (String)"Column for update must not be null or blank");
        LinkedHashMap<String, Object> updates = new LinkedHashMap<String, Object>(this.columnsToUpdate);
        updates.put(key, value);
        return new Update(updates);
    }
}

