/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.util.ArrayList;
import java.util.Map;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.dialect.BindMarker;
import org.springframework.data.r2dbc.dialect.BindMarkers;
import org.springframework.data.r2dbc.dialect.MutableBindings;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.BoundAssignments;
import org.springframework.data.r2dbc.query.QueryMapper;
import org.springframework.data.r2dbc.query.Update;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.sql.AssignValue;
import org.springframework.data.relational.core.sql.Assignment;
import org.springframework.data.relational.core.sql.Assignments;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    public UpdateMapper(R2dbcConverter converter) {
        super(converter);
    }

    public BoundAssignments getMappedObject(BindMarkers markers, Update update, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        return this.getMappedObject(markers, update.getAssignments(), table, entity);
    }

    public BoundAssignments getMappedObject(BindMarkers markers, Map<String, ? extends Object> assignments, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)markers, (String)"BindMarkers must not be null!");
        Assert.notNull(assignments, (String)"Assignments must not be null!");
        Assert.notNull((Object)table, (String)"Table must not be null!");
        MutableBindings bindings = new MutableBindings(markers);
        ArrayList<Assignment> result = new ArrayList<Assignment>();
        assignments.forEach((column, value) -> {
            Assignment assignment = this.getAssignment((String)column, value, bindings, table, entity);
            result.add(assignment);
        });
        return new BoundAssignments(bindings, result);
    }

    private Assignment getAssignment(String columnName, Object value, MutableBindings bindings, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Class<?> typeHint;
        Object mappedValue;
        QueryMapper.Field propertyField = this.createPropertyField(entity, columnName, this.getMappingContext());
        Column column = table.column(propertyField.getMappedColumnName());
        TypeInformation actualType = propertyField.getTypeHint().getRequiredActualType();
        if (value instanceof SettableValue) {
            SettableValue settableValue = (SettableValue)value;
            mappedValue = this.convertValue(settableValue.getValue(), propertyField.getTypeHint());
            typeHint = this.getTypeHint(mappedValue, actualType.getType(), settableValue);
        } else {
            mappedValue = this.convertValue(value, propertyField.getTypeHint());
            if (mappedValue == null) {
                return Assignments.value((Column)column, (Expression)SQL.nullLiteral());
            }
            typeHint = actualType.getType();
        }
        return this.createAssignment(column, mappedValue, typeHint, bindings);
    }

    private Assignment createAssignment(Column column, Object value, Class<?> type, MutableBindings bindings) {
        BindMarker bindMarker = bindings.nextMarker(column.getName());
        AssignValue assignValue = Assignments.value((Column)column, (Expression)SQL.bindMarker((String)bindMarker.getPlaceholder()));
        if (value == null) {
            bindings.bindNull(bindMarker, type);
        } else {
            bindings.bind(bindMarker, value);
        }
        return assignValue;
    }
}

