/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.repository.support;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.reactivestreams.Publisher;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.core.DatabaseClient;
import org.springframework.data.r2dbc.core.PreparedOperation;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.StatementMapper;
import org.springframework.data.r2dbc.query.Criteria;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.StatementBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.repository.reactive.ReactiveCrudRepository;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleR2dbcRepository<T, ID>
implements ReactiveCrudRepository<T, ID> {
    @NonNull
    private final RelationalEntityInformation<T, ID> entity;
    @NonNull
    private final DatabaseClient databaseClient;
    @NonNull
    private final R2dbcConverter converter;
    @NonNull
    private final ReactiveDataAccessStrategy accessStrategy;

    public <S extends T> Mono<S> save(S objectToSave) {
        Assert.notNull(objectToSave, (String)"Object to save must not be null!");
        if (this.entity.isNew(objectToSave)) {
            return this.databaseClient.insert().into(this.entity.getJavaType()).table(this.entity.getTableName()).using(objectToSave).map(this.converter.populateIdIfNecessary(objectToSave)).first().defaultIfEmpty(objectToSave);
        }
        return this.databaseClient.update().table(this.entity.getJavaType()).table(this.entity.getTableName()).using(objectToSave).then().thenReturn(objectToSave);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Objects to save must not be null!");
        return Flux.fromIterable(objectsToSave).concatMap(this::save);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> objectsToSave) {
        Assert.notNull(objectsToSave, (String)"Object publisher must not be null!");
        return Flux.from(objectsToSave).concatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        List<String> columns = this.accessStrategy.getAllColumns(this.entity.getJavaType());
        String idColumnName = this.getIdColumnName();
        StatementMapper.TypedStatementMapper mapper = this.accessStrategy.getStatementMapper().forType(this.entity.getJavaType());
        StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.entity.getTableName()).withProjection(columns).withCriteria(Criteria.where(idColumnName).is(id));
        PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
        return this.databaseClient.execute().sql(operation).as(this.entity.getJavaType()).fetch().one();
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        String idColumnName = this.getIdColumnName();
        StatementMapper.TypedStatementMapper mapper = this.accessStrategy.getStatementMapper().forType(this.entity.getJavaType());
        StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.entity.getTableName()).withProjection(Collections.singletonList(idColumnName)).withCriteria(Criteria.where(idColumnName).is(id));
        PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
        return this.databaseClient.execute().sql(operation).map((r, md) -> r).first().hasElement();
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        return Mono.from(publisher).flatMap(this::findById).hasElement();
    }

    public Flux<T> findAll() {
        return this.databaseClient.select().from(this.entity.getJavaType()).fetch().all();
    }

    public Flux<T> findAllById(Iterable<ID> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.findAllById((Publisher<ID>)Flux.fromIterable(iterable));
    }

    public Flux<T> findAllById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            List<String> columns = this.accessStrategy.getAllColumns(this.entity.getJavaType());
            String idColumnName = this.getIdColumnName();
            StatementMapper.TypedStatementMapper mapper = this.accessStrategy.getStatementMapper().forType(this.entity.getJavaType());
            StatementMapper.SelectSpec selectSpec = mapper.createSelect(this.entity.getTableName()).withProjection(columns).withCriteria(Criteria.where(idColumnName).in((Collection<? extends Object>)ids));
            PreparedOperation<?> operation = mapper.getMappedObject(selectSpec);
            return this.databaseClient.execute().sql(operation).as(this.entity.getJavaType()).fetch().all();
        });
    }

    public Mono<Long> count() {
        Table table = Table.create((String)this.entity.getTableName());
        Select select = StatementBuilder.select((Expression)Functions.count((Expression[])new Expression[]{table.column(this.getIdColumnName())})).from(table).build();
        return this.databaseClient.execute().sql(SqlRenderer.toString((Select)select)).map((r, md) -> (Long)r.get((Object)0, Long.class)).first().defaultIfEmpty((Object)0L);
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"Id must not be null!");
        return this.databaseClient.delete().from(this.entity.getJavaType()).table(this.entity.getTableName()).matching(Criteria.where(this.getIdColumnName()).is(id)).fetch().rowsUpdated().then();
    }

    public Mono<Void> deleteById(Publisher<ID> idPublisher) {
        Assert.notNull(idPublisher, (String)"The Id Publisher must not be null!");
        StatementMapper.TypedStatementMapper statementMapper = this.accessStrategy.getStatementMapper().forType(this.entity.getJavaType());
        return Flux.from(idPublisher).buffer().filter(ids -> !ids.isEmpty()).concatMap(ids -> {
            if (ids.isEmpty()) {
                return Flux.empty();
            }
            return this.databaseClient.delete().from(this.entity.getJavaType()).table(this.entity.getTableName()).matching(Criteria.where(this.getIdColumnName()).in((Collection<? extends Object>)ids)).fetch().rowsUpdated();
        }).then();
    }

    public Mono<Void> delete(T objectToDelete) {
        Assert.notNull(objectToDelete, (String)"Object to delete must not be null!");
        return this.deleteById(this.entity.getRequiredId(objectToDelete));
    }

    public Mono<Void> deleteAll(Iterable<? extends T> iterable) {
        Assert.notNull(iterable, (String)"The iterable of Id's must not be null!");
        return this.deleteAll((Publisher<? extends T>)Flux.fromIterable(iterable));
    }

    public Mono<Void> deleteAll(Publisher<? extends T> objectPublisher) {
        Assert.notNull(objectPublisher, (String)"The Object Publisher must not be null!");
        Flux idPublisher = Flux.from(objectPublisher).map(arg_0 -> this.entity.getRequiredId(arg_0));
        return this.deleteById((Publisher<ID>)idPublisher);
    }

    public Mono<Void> deleteAll() {
        return this.databaseClient.delete().from(this.entity.getTableName()).then();
    }

    private String getIdColumnName() {
        return ((RelationalPersistentProperty)((RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(this.entity.getJavaType())).getRequiredIdProperty()).getColumnName();
    }

    public SimpleR2dbcRepository(@NonNull RelationalEntityInformation<T, ID> entity, @NonNull DatabaseClient databaseClient, @NonNull R2dbcConverter converter, @NonNull ReactiveDataAccessStrategy accessStrategy) {
        if (entity == null) {
            throw new IllegalArgumentException("entity is marked @NonNull but is null");
        }
        if (databaseClient == null) {
            throw new IllegalArgumentException("databaseClient is marked @NonNull but is null");
        }
        if (converter == null) {
            throw new IllegalArgumentException("converter is marked @NonNull but is null");
        }
        if (accessStrategy == null) {
            throw new IllegalArgumentException("accessStrategy is marked @NonNull but is null");
        }
        this.entity = entity;
        this.databaseClient = databaseClient;
        this.converter = converter;
        this.accessStrategy = accessStrategy;
    }
}

