/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.cluster.ClusterClientOptions;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.resource.ClientResources;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.PassThroughExceptionTranslationStrategy;
import org.springframework.data.redis.RedisConnectionFailureException;
import org.springframework.data.redis.connection.ClusterCommandExecutor;
import org.springframework.data.redis.connection.ClusterTopologyProvider;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisClusterConnection;
import org.springframework.data.redis.connection.RedisConfiguration;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisSentinelConnection;
import org.springframework.data.redis.connection.RedisSocketConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.RedisStaticMasterReplicaConfiguration;
import org.springframework.data.redis.connection.lettuce.ClusterConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettuceClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceClusterTopologyProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettucePool;
import org.springframework.data.redis.connection.lettuce.LettucePoolingClientConfiguration;
import org.springframework.data.redis.connection.lettuce.LettucePoolingConnectionProvider;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisClusterConnection;
import org.springframework.data.redis.connection.lettuce.LettuceReactiveRedisConnection;
import org.springframework.data.redis.connection.lettuce.LettuceSentinelConnection;
import org.springframework.data.redis.connection.lettuce.StandaloneConnectionProvider;
import org.springframework.data.redis.connection.lettuce.StaticMasterReplicaConnectionProvider;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class LettuceConnectionFactory
implements InitializingBean,
DisposableBean,
RedisConnectionFactory,
ReactiveRedisConnectionFactory {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new PassThroughExceptionTranslationStrategy(LettuceConverters.exceptionConverter());
    private final Log log = LogFactory.getLog(this.getClass());
    private final LettuceClientConfiguration clientConfiguration;
    @Nullable
    private AbstractRedisClient client;
    @Nullable
    private LettuceConnectionProvider connectionProvider;
    @Nullable
    private LettuceConnectionProvider reactiveConnectionProvider;
    private boolean validateConnection = false;
    private boolean shareNativeConnection = true;
    private boolean eagerInitialization = false;
    @Nullable
    private SharedConnection<byte[]> connection;
    @Nullable
    private SharedConnection<ByteBuffer> reactiveConnection;
    @Nullable
    private LettucePool pool;
    private final Object connectionMonitor = new Object();
    private boolean convertPipelineAndTxResults = true;
    private RedisStandaloneConfiguration standaloneConfig = new RedisStandaloneConfiguration("localhost", 6379);
    private LettuceConnection.PipeliningFlushPolicy pipeliningFlushPolicy = LettuceConnection.PipeliningFlushPolicy.flushEachCommand();
    @Nullable
    private RedisConfiguration configuration;
    @Nullable
    private ClusterCommandExecutor clusterCommandExecutor;

    public LettuceConnectionFactory() {
        this(new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration configuration) {
        this(configuration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    private LettuceConnectionFactory(LettuceClientConfiguration clientConfig) {
        Assert.notNull((Object)clientConfig, (String)"LettuceClientConfiguration must not be null!");
        this.clientConfiguration = clientConfig;
        this.configuration = this.standaloneConfig;
    }

    public LettuceConnectionFactory(String host, int port) {
        this(new RedisStandaloneConfiguration(host, port), (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisConfiguration redisConfiguration) {
        this(redisConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration) {
        this(sentinelConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfiguration) {
        this(clusterConfiguration, (LettuceClientConfiguration)new MutableLettuceClientConfiguration());
    }

    @Deprecated
    public LettuceConnectionFactory(LettucePool pool) {
        this(new MutableLettuceClientConfiguration());
        this.pool = pool;
    }

    public LettuceConnectionFactory(RedisStandaloneConfiguration standaloneConfig, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)standaloneConfig, (String)"RedisStandaloneConfiguration must not be null!");
        this.standaloneConfig = standaloneConfig;
        this.configuration = this.standaloneConfig;
    }

    public LettuceConnectionFactory(RedisConfiguration redisConfiguration, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)redisConfiguration, (String)"RedisConfiguration must not be null!");
        this.configuration = redisConfiguration;
    }

    public LettuceConnectionFactory(RedisSentinelConfiguration sentinelConfiguration, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)sentinelConfiguration, (String)"RedisSentinelConfiguration must not be null!");
        this.configuration = sentinelConfiguration;
    }

    public LettuceConnectionFactory(RedisClusterConfiguration clusterConfiguration, LettuceClientConfiguration clientConfig) {
        this(clientConfig);
        Assert.notNull((Object)clusterConfiguration, (String)"RedisClusterConfiguration must not be null!");
        this.configuration = clusterConfiguration;
    }

    public void afterPropertiesSet() {
        this.client = this.createClient();
        this.connectionProvider = new ExceptionTranslatingConnectionProvider(this.createConnectionProvider(this.client, LettuceConnection.CODEC));
        this.reactiveConnectionProvider = new ExceptionTranslatingConnectionProvider(this.createConnectionProvider(this.client, LettuceReactiveRedisConnection.CODEC));
        if (this.isClusterAware()) {
            this.clusterCommandExecutor = new ClusterCommandExecutor(new LettuceClusterTopologyProvider((RedisClusterClient)this.client), new LettuceClusterConnection.LettuceClusterNodeResourceProvider(this.connectionProvider), EXCEPTION_TRANSLATION);
        }
        if (this.getEagerInitialization() && this.getShareNativeConnection()) {
            this.initConnection();
        }
    }

    public void destroy() {
        block5: {
            this.resetConnection();
            this.dispose(this.connectionProvider);
            this.dispose(this.reactiveConnectionProvider);
            try {
                Duration quietPeriod = this.clientConfiguration.getShutdownQuietPeriod();
                Duration timeout = this.clientConfiguration.getShutdownTimeout();
                this.client.shutdown(quietPeriod.toMillis(), timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block5;
                this.log.warn((Object)((this.client != null ? ClassUtils.getShortName(this.client.getClass()) : "LettuceClient") + " did not shut down gracefully."), (Throwable)e);
            }
        }
        if (this.clusterCommandExecutor != null) {
            try {
                this.clusterCommandExecutor.destroy();
            }
            catch (Exception ex) {
                this.log.warn((Object)"Cannot properly close cluster command executor", (Throwable)ex);
            }
        }
    }

    private void dispose(LettuceConnectionProvider connectionProvider) {
        block3: {
            if (connectionProvider instanceof DisposableBean) {
                try {
                    ((DisposableBean)connectionProvider).destroy();
                }
                catch (Exception e) {
                    if (!this.log.isWarnEnabled()) break block3;
                    this.log.warn((Object)(connectionProvider + " did not shut down gracefully."), (Throwable)e);
                }
            }
        }
    }

    @Override
    public RedisConnection getConnection() {
        if (this.isClusterAware()) {
            return this.getClusterConnection();
        }
        LettuceConnection connection = this.doCreateLettuceConnection(this.getSharedConnection(), this.connectionProvider, this.getTimeout(), this.getDatabase());
        connection.setConvertPipelineAndTxResults(this.convertPipelineAndTxResults);
        return connection;
    }

    @Override
    public RedisClusterConnection getClusterConnection() {
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        RedisClusterClient clusterClient = (RedisClusterClient)this.client;
        StatefulRedisClusterConnection sharedConnection = this.getShareNativeConnection() ? (StatefulRedisClusterConnection)this.getOrCreateSharedConnection().getConnection() : null;
        LettuceClusterTopologyProvider topologyProvider = new LettuceClusterTopologyProvider(clusterClient);
        return this.doCreateLettuceClusterConnection((StatefulRedisClusterConnection<byte[], byte[]>)sharedConnection, this.connectionProvider, topologyProvider, this.clusterCommandExecutor, this.clientConfiguration.getCommandTimeout());
    }

    protected LettuceConnection doCreateLettuceConnection(@Nullable StatefulRedisConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, long timeout, int database) {
        LettuceConnection connection = new LettuceConnection(sharedConnection, connectionProvider, timeout, database);
        connection.setPipeliningFlushPolicy(this.pipeliningFlushPolicy);
        return connection;
    }

    protected LettuceClusterConnection doCreateLettuceClusterConnection(@Nullable StatefulRedisClusterConnection<byte[], byte[]> sharedConnection, LettuceConnectionProvider connectionProvider, ClusterTopologyProvider topologyProvider, ClusterCommandExecutor clusterCommandExecutor, Duration commandTimeout) {
        LettuceClusterConnection connection = new LettuceClusterConnection(sharedConnection, connectionProvider, topologyProvider, clusterCommandExecutor, commandTimeout);
        connection.setPipeliningFlushPolicy(this.pipeliningFlushPolicy);
        return connection;
    }

    @Override
    public LettuceReactiveRedisConnection getReactiveConnection() {
        if (this.isClusterAware()) {
            return this.getReactiveClusterConnection();
        }
        return this.getShareNativeConnection() ? new LettuceReactiveRedisConnection(this.getSharedReactiveConnection(), this.reactiveConnectionProvider) : new LettuceReactiveRedisConnection(this.reactiveConnectionProvider);
    }

    @Override
    public LettuceReactiveRedisClusterConnection getReactiveClusterConnection() {
        if (!this.isClusterAware()) {
            throw new InvalidDataAccessApiUsageException("Cluster is not configured!");
        }
        RedisClusterClient client = (RedisClusterClient)this.client;
        return this.getShareNativeConnection() ? new LettuceReactiveRedisClusterConnection(this.getSharedReactiveConnection(), this.reactiveConnectionProvider, client) : new LettuceReactiveRedisClusterConnection(this.reactiveConnectionProvider, client);
    }

    public void initConnection() {
        this.resetConnection();
        this.getSharedConnection();
        this.getSharedReactiveConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetConnection() {
        Optionals.toStream((Optional[])new Optional[]{Optional.ofNullable(this.connection), Optional.ofNullable(this.reactiveConnection)}).forEach(SharedConnection::resetConnection);
        Object object = this.connectionMonitor;
        synchronized (object) {
            this.connection = null;
            this.reactiveConnection = null;
        }
    }

    public void validateConnection() {
        this.getOrCreateSharedConnection().validateConnection();
        this.getOrCreateSharedReactiveConnection().validateConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedConnection<byte[]> getOrCreateSharedConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.connection == null) {
                this.connection = new SharedConnection(this.connectionProvider);
            }
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SharedConnection<ByteBuffer> getOrCreateSharedReactiveConnection() {
        Object object = this.connectionMonitor;
        synchronized (object) {
            if (this.reactiveConnection == null) {
                this.reactiveConnection = new SharedConnection(this.reactiveConnectionProvider);
            }
            return this.reactiveConnection;
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return EXCEPTION_TRANSLATION.translate(ex);
    }

    public String getHostName() {
        return RedisConfiguration.getHostOrElse(this.configuration, this.standaloneConfig::getHostName);
    }

    @Deprecated
    public void setHostName(String hostName) {
        this.standaloneConfig.setHostName(hostName);
    }

    public int getPort() {
        return RedisConfiguration.getPortOrElse(this.configuration, this.standaloneConfig::getPort);
    }

    @Deprecated
    public void setPort(int port) {
        this.standaloneConfig.setPort(port);
    }

    public void setPipeliningFlushPolicy(LettuceConnection.PipeliningFlushPolicy pipeliningFlushPolicy) {
        Assert.notNull((Object)pipeliningFlushPolicy, (String)"PipeliningFlushingPolicy must not be null!");
        this.pipeliningFlushPolicy = pipeliningFlushPolicy;
    }

    public long getTimeout() {
        return this.getClientTimeout();
    }

    @Deprecated
    public void setTimeout(long timeout) {
        this.getMutableConfiguration().setTimeout(Duration.ofMillis(timeout));
    }

    public boolean isUseSsl() {
        return this.clientConfiguration.isUseSsl();
    }

    @Deprecated
    public void setUseSsl(boolean useSsl) {
        this.getMutableConfiguration().setUseSsl(useSsl);
    }

    public boolean isVerifyPeer() {
        return this.clientConfiguration.isVerifyPeer();
    }

    @Deprecated
    public void setVerifyPeer(boolean verifyPeer) {
        this.getMutableConfiguration().setVerifyPeer(verifyPeer);
    }

    public boolean isStartTls() {
        return this.clientConfiguration.isStartTls();
    }

    @Deprecated
    public void setStartTls(boolean startTls) {
        this.getMutableConfiguration().setStartTls(startTls);
    }

    public boolean getValidateConnection() {
        return this.validateConnection;
    }

    public void setValidateConnection(boolean validateConnection) {
        this.validateConnection = validateConnection;
    }

    public boolean getShareNativeConnection() {
        return this.shareNativeConnection;
    }

    public void setShareNativeConnection(boolean shareNativeConnection) {
        this.shareNativeConnection = shareNativeConnection;
    }

    public boolean getEagerInitialization() {
        return this.eagerInitialization;
    }

    public void setEagerInitialization(boolean eagerInitialization) {
        this.eagerInitialization = eagerInitialization;
    }

    public int getDatabase() {
        return RedisConfiguration.getDatabaseOrElse(this.configuration, this.standaloneConfig::getDatabase);
    }

    public void setDatabase(int index) {
        Assert.isTrue((index >= 0 ? 1 : 0) != 0, (String)"invalid DB index (a positive index required)");
        if (RedisConfiguration.isDatabaseIndexAware(this.configuration)) {
            ((RedisConfiguration.WithDatabaseIndex)((Object)this.configuration)).setDatabase(index);
            return;
        }
        this.standaloneConfig.setDatabase(index);
    }

    @Nullable
    public String getClientName() {
        return this.clientConfiguration.getClientName().orElse(null);
    }

    @Deprecated
    public void setClientName(@Nullable String clientName) {
        this.getMutableConfiguration().setClientName(clientName);
    }

    @Nullable
    private String getRedisUsername() {
        return RedisConfiguration.getUsernameOrElse(this.configuration, this.standaloneConfig::getUsername);
    }

    @Nullable
    public String getPassword() {
        return this.getRedisPassword().map(String::new).orElse(null);
    }

    private RedisPassword getRedisPassword() {
        return RedisConfiguration.getPasswordOrElse(this.configuration, this.standaloneConfig::getPassword);
    }

    @Deprecated
    public void setPassword(String password) {
        if (RedisConfiguration.isAuthenticationAware(this.configuration)) {
            ((RedisConfiguration.WithPassword)((Object)this.configuration)).setPassword(password);
            return;
        }
        this.standaloneConfig.setPassword(RedisPassword.of(password));
    }

    public long getShutdownTimeout() {
        return this.clientConfiguration.getShutdownTimeout().toMillis();
    }

    @Deprecated
    public void setShutdownTimeout(long shutdownTimeout) {
        this.getMutableConfiguration().setShutdownTimeout(Duration.ofMillis(shutdownTimeout));
    }

    public ClientResources getClientResources() {
        return this.clientConfiguration.getClientResources().orElse(null);
    }

    @Deprecated
    public void setClientResources(ClientResources clientResources) {
        this.getMutableConfiguration().setClientResources(clientResources);
    }

    public LettuceClientConfiguration getClientConfiguration() {
        return this.clientConfiguration;
    }

    public RedisStandaloneConfiguration getStandaloneConfiguration() {
        return this.standaloneConfig;
    }

    @Nullable
    public RedisSocketConfiguration getSocketConfiguration() {
        return this.isDomainSocketAware() ? (RedisSocketConfiguration)this.configuration : null;
    }

    @Nullable
    public RedisSentinelConfiguration getSentinelConfiguration() {
        return this.isRedisSentinelAware() ? (RedisSentinelConfiguration)this.configuration : null;
    }

    @Nullable
    public RedisClusterConfiguration getClusterConfiguration() {
        return this.isClusterAware() ? (RedisClusterConfiguration)this.configuration : null;
    }

    @Override
    public boolean getConvertPipelineAndTxResults() {
        return this.convertPipelineAndTxResults;
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    private boolean isStaticMasterReplicaAware() {
        return RedisConfiguration.isStaticMasterReplicaConfiguration(this.configuration);
    }

    public boolean isRedisSentinelAware() {
        return RedisConfiguration.isSentinelConfiguration(this.configuration);
    }

    private boolean isDomainSocketAware() {
        return RedisConfiguration.isDomainSocketConfiguration(this.configuration);
    }

    public boolean isClusterAware() {
        return RedisConfiguration.isClusterConfiguration(this.configuration);
    }

    @Nullable
    protected StatefulRedisConnection<byte[], byte[]> getSharedConnection() {
        return this.shareNativeConnection ? (StatefulRedisConnection)this.getOrCreateSharedConnection().getConnection() : null;
    }

    @Nullable
    protected StatefulConnection<ByteBuffer, ByteBuffer> getSharedReactiveConnection() {
        return this.shareNativeConnection ? this.getOrCreateSharedReactiveConnection().getConnection() : null;
    }

    private LettuceConnectionProvider createConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec) {
        if (this.pool != null) {
            return new LettuceConnection.LettucePoolConnectionProvider(this.pool);
        }
        LettuceConnectionProvider connectionProvider = this.doCreateConnectionProvider(client, codec);
        if (this.clientConfiguration instanceof LettucePoolingClientConfiguration) {
            return new LettucePoolingConnectionProvider(connectionProvider, (LettucePoolingClientConfiguration)this.clientConfiguration);
        }
        return connectionProvider;
    }

    protected LettuceConnectionProvider doCreateConnectionProvider(AbstractRedisClient client, RedisCodec<?, ?> codec) {
        ReadFrom readFrom = this.getClientConfiguration().getReadFrom().orElse(null);
        if (this.isStaticMasterReplicaAware()) {
            List<RedisURI> nodes = ((RedisStaticMasterReplicaConfiguration)this.configuration).getNodes().stream().map(it -> this.createRedisURIAndApplySettings(it.getHostName(), it.getPort())).peek(it -> it.setDatabase(this.getDatabase())).collect(Collectors.toList());
            return new StaticMasterReplicaConnectionProvider((RedisClient)client, codec, nodes, readFrom);
        }
        if (this.isClusterAware()) {
            return new ClusterConnectionProvider((RedisClusterClient)client, codec, readFrom);
        }
        return new StandaloneConnectionProvider((RedisClient)client, codec, readFrom);
    }

    protected AbstractRedisClient createClient() {
        if (this.isStaticMasterReplicaAware()) {
            RedisClient redisClient = this.clientConfiguration.getClientResources().map(RedisClient::create).orElseGet(RedisClient::create);
            this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
            return redisClient;
        }
        if (this.isRedisSentinelAware()) {
            RedisURI redisURI = this.getSentinelRedisURI();
            RedisClient redisClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)redisURI)).orElseGet(() -> RedisClient.create((RedisURI)redisURI));
            this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
            return redisClient;
        }
        if (this.isClusterAware()) {
            ArrayList<RedisURI> initialUris = new ArrayList<RedisURI>();
            RedisConfiguration.ClusterConfiguration configuration = (RedisConfiguration.ClusterConfiguration)((Object)this.configuration);
            for (RedisNode node : configuration.getClusterNodes()) {
                initialUris.add(this.createRedisURIAndApplySettings(node.getHost(), node.getPort()));
            }
            RedisClusterClient clusterClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClusterClient.create((ClientResources)clientResources, (Iterable)initialUris)).orElseGet(() -> RedisClusterClient.create((Iterable)initialUris));
            clusterClient.setOptions(this.getClusterClientOptions(configuration));
            return clusterClient;
        }
        RedisURI uri = this.isDomainSocketAware() ? this.createRedisSocketURIAndApplySettings(((RedisConfiguration.DomainSocketConfiguration)((Object)this.configuration)).getSocket()) : this.createRedisURIAndApplySettings(this.getHostName(), this.getPort());
        RedisClient redisClient = this.clientConfiguration.getClientResources().map(clientResources -> RedisClient.create((ClientResources)clientResources, (RedisURI)uri)).orElseGet(() -> RedisClient.create((RedisURI)uri));
        this.clientConfiguration.getClientOptions().ifPresent(arg_0 -> ((RedisClient)redisClient).setOptions(arg_0));
        return redisClient;
    }

    private ClusterClientOptions getClusterClientOptions(RedisConfiguration.ClusterConfiguration configuration) {
        Optional<ClientOptions> clientOptions = this.clientConfiguration.getClientOptions();
        ClusterClientOptions clusterClientOptions = clientOptions.filter(ClusterClientOptions.class::isInstance).map(ClusterClientOptions.class::cast).orElseGet(() -> clientOptions.map(it -> ClusterClientOptions.builder((ClientOptions)it).build()).orElseGet(ClusterClientOptions::create));
        if (configuration.getMaxRedirects() != null) {
            return clusterClientOptions.mutate().maxRedirects(configuration.getMaxRedirects().intValue()).build();
        }
        return clusterClientOptions;
    }

    private RedisURI getSentinelRedisURI() {
        RedisURI redisUri = LettuceConverters.sentinelConfigurationToRedisURI((RedisSentinelConfiguration)this.configuration);
        LettuceConnectionFactory.applyToAll(redisUri, it -> {
            this.clientConfiguration.getClientName().ifPresent(arg_0 -> ((RedisURI)it).setClientName(arg_0));
            it.setSsl(this.clientConfiguration.isUseSsl());
            it.setVerifyPeer(this.clientConfiguration.isVerifyPeer());
            it.setStartTls(this.clientConfiguration.isStartTls());
            it.setTimeout(this.clientConfiguration.getCommandTimeout());
        });
        redisUri.setDatabase(this.getDatabase());
        return redisUri;
    }

    private static void applyToAll(RedisURI source, Consumer<RedisURI> action) {
        action.accept(source);
        source.getSentinels().forEach(action);
    }

    private RedisURI createRedisURIAndApplySettings(String host, int port) {
        RedisURI.Builder builder = RedisURI.Builder.redis((String)host, (int)port);
        this.applyAuthentication(builder);
        this.clientConfiguration.getClientName().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withClientName(arg_0));
        builder.withDatabase(this.getDatabase());
        builder.withSsl(this.clientConfiguration.isUseSsl());
        builder.withVerifyPeer(this.clientConfiguration.isVerifyPeer());
        builder.withStartTls(this.clientConfiguration.isStartTls());
        builder.withTimeout(this.clientConfiguration.getCommandTimeout());
        return builder.build();
    }

    private RedisURI createRedisSocketURIAndApplySettings(String socketPath) {
        RedisURI.Builder builder = RedisURI.Builder.socket((String)socketPath);
        this.applyAuthentication(builder);
        builder.withDatabase(this.getDatabase());
        builder.withTimeout(this.clientConfiguration.getCommandTimeout());
        return builder.build();
    }

    private void applyAuthentication(RedisURI.Builder builder) {
        String username = this.getRedisUsername();
        if (StringUtils.hasText((String)username)) {
            builder.withAuthentication(username, (CharSequence)new String(this.getRedisPassword().toOptional().orElse(new char[0])));
        } else {
            this.getRedisPassword().toOptional().ifPresent(arg_0 -> ((RedisURI.Builder)builder).withPassword(arg_0));
        }
    }

    @Override
    public RedisSentinelConnection getSentinelConnection() {
        return new LettuceSentinelConnection(this.connectionProvider);
    }

    private MutableLettuceClientConfiguration getMutableConfiguration() {
        Assert.state((boolean)(this.clientConfiguration instanceof MutableLettuceClientConfiguration), () -> String.format("Client configuration must be instance of MutableLettuceClientConfiguration but is %s", ClassUtils.getShortName(this.clientConfiguration.getClass())));
        return (MutableLettuceClientConfiguration)this.clientConfiguration;
    }

    private long getClientTimeout() {
        return this.clientConfiguration.getCommandTimeout().toMillis();
    }

    private static class ExceptionTranslatingConnectionProvider
    implements LettuceConnectionProvider,
    LettuceConnectionProvider.TargetAware,
    DisposableBean {
        private final LettuceConnectionProvider delegate;

        public ExceptionTranslatingConnectionProvider(LettuceConnectionProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType) {
            try {
                return this.delegate.getConnection(connectionType);
            }
            catch (RuntimeException e) {
                throw this.translateException(e);
            }
        }

        @Override
        public <T extends StatefulConnection<?, ?>> T getConnection(Class<T> connectionType, RedisURI redisURI) {
            try {
                return ((LettuceConnectionProvider.TargetAware)((Object)this.delegate)).getConnection(connectionType, redisURI);
            }
            catch (RuntimeException e) {
                throw this.translateException(e);
            }
        }

        @Override
        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType) {
            CompletableFuture future = new CompletableFuture();
            this.delegate.getConnectionAsync(connectionType).whenComplete((t, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally(this.translateException((Throwable)throwable));
                } else {
                    future.complete(t);
                }
            });
            return future;
        }

        @Override
        public <T extends StatefulConnection<?, ?>> CompletionStage<T> getConnectionAsync(Class<T> connectionType, RedisURI redisURI) {
            CompletableFuture future = new CompletableFuture();
            ((LettuceConnectionProvider.TargetAware)((Object)this.delegate)).getConnectionAsync(connectionType, redisURI).whenComplete((t, throwable) -> {
                if (throwable != null) {
                    future.completeExceptionally(this.translateException((Throwable)throwable));
                } else {
                    future.complete(t);
                }
            });
            return future;
        }

        @Override
        public void release(StatefulConnection<?, ?> connection) {
            this.delegate.release(connection);
        }

        @Override
        public CompletableFuture<Void> releaseAsync(StatefulConnection<?, ?> connection) {
            return this.delegate.releaseAsync(connection);
        }

        public void destroy() throws Exception {
            if (this.delegate instanceof DisposableBean) {
                ((DisposableBean)this.delegate).destroy();
            }
        }

        private RuntimeException translateException(Throwable e) {
            return e instanceof RedisConnectionFailureException ? (RedisConnectionFailureException)((Object)e) : new RedisConnectionFailureException("Unable to connect to Redis", e);
        }
    }

    static class MutableLettuceClientConfiguration
    implements LettuceClientConfiguration {
        private boolean useSsl;
        private boolean verifyPeer = true;
        private boolean startTls;
        @Nullable
        private ClientResources clientResources;
        @Nullable
        private String clientName;
        private Duration timeout = Duration.ofSeconds(60L);
        private Duration shutdownTimeout = Duration.ofMillis(100L);

        MutableLettuceClientConfiguration() {
        }

        @Override
        public boolean isUseSsl() {
            return this.useSsl;
        }

        void setUseSsl(boolean useSsl) {
            this.useSsl = useSsl;
        }

        @Override
        public boolean isVerifyPeer() {
            return this.verifyPeer;
        }

        void setVerifyPeer(boolean verifyPeer) {
            this.verifyPeer = verifyPeer;
        }

        @Override
        public boolean isStartTls() {
            return this.startTls;
        }

        void setStartTls(boolean startTls) {
            this.startTls = startTls;
        }

        @Override
        public Optional<ClientResources> getClientResources() {
            return Optional.ofNullable(this.clientResources);
        }

        void setClientResources(ClientResources clientResources) {
            this.clientResources = clientResources;
        }

        @Override
        public Optional<ClientOptions> getClientOptions() {
            return Optional.empty();
        }

        @Override
        public Optional<ReadFrom> getReadFrom() {
            return Optional.empty();
        }

        @Override
        public Optional<String> getClientName() {
            return Optional.ofNullable(this.clientName);
        }

        void setClientName(@Nullable String clientName) {
            this.clientName = clientName;
        }

        @Override
        public Duration getCommandTimeout() {
            return this.timeout;
        }

        void setTimeout(Duration timeout) {
            this.timeout = timeout;
        }

        @Override
        public Duration getShutdownTimeout() {
            return this.shutdownTimeout;
        }

        void setShutdownTimeout(Duration shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
        }

        @Override
        public Duration getShutdownQuietPeriod() {
            return this.shutdownTimeout;
        }
    }

    class SharedConnection<E> {
        private final LettuceConnectionProvider connectionProvider;
        private final Object connectionMonitor = new Object();
        @Nullable
        private StatefulConnection<E, E> connection;

        SharedConnection(LettuceConnectionProvider connectionProvider) {
            this.connectionProvider = connectionProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        StatefulConnection<E, E> getConnection() {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.connection == null) {
                    this.connection = this.getNativeConnection();
                }
                if (LettuceConnectionFactory.this.getValidateConnection()) {
                    this.validateConnection();
                }
                return this.connection;
            }
        }

        private StatefulConnection<E, E> getNativeConnection() {
            return this.connectionProvider.getConnection(StatefulConnection.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void validateConnection() {
            Object object = this.connectionMonitor;
            synchronized (object) {
                boolean valid = false;
                if (this.connection != null && this.connection.isOpen()) {
                    try {
                        if (this.connection instanceof StatefulRedisConnection) {
                            ((StatefulRedisConnection)this.connection).sync().ping();
                        }
                        if (this.connection instanceof StatefulRedisClusterConnection) {
                            ((StatefulRedisClusterConnection)this.connection).sync().ping();
                        }
                        valid = true;
                    }
                    catch (Exception e) {
                        LettuceConnectionFactory.this.log.debug((Object)"Validation failed", (Throwable)e);
                    }
                }
                if (!valid) {
                    LettuceConnectionFactory.this.log.info((Object)"Validation of shared connection failed. Creating a new connection.");
                    this.resetConnection();
                    this.connection = this.getNativeConnection();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resetConnection() {
            Object object = this.connectionMonitor;
            synchronized (object) {
                if (this.connection != null) {
                    this.connectionProvider.release(this.connection);
                }
                this.connection = null;
            }
        }
    }
}

