/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class PersistentPropertyPathExtension {
    private final RelationalPersistentEntity<?> entity;
    @Nullable
    private final PersistentPropertyPath<RelationalPersistentProperty> path;
    private final MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> context;

    public PersistentPropertyPathExtension(MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> context, RelationalPersistentEntity<?> entity) {
        Assert.notNull(context, (String)"Context must not be null.");
        Assert.notNull(entity, (String)"Entity must not be null.");
        this.context = context;
        this.entity = entity;
        this.path = null;
    }

    public PersistentPropertyPathExtension(MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> context, PersistentPropertyPath<RelationalPersistentProperty> path) {
        Assert.notNull(context, (String)"Context must not be null.");
        Assert.notNull(path, (String)"Path must not be null.");
        Assert.notNull((Object)path.getBaseProperty(), (String)"Path must not be empty.");
        this.context = context;
        this.entity = ((RelationalPersistentProperty)path.getBaseProperty()).getOwner();
        this.path = path;
    }

    public boolean isEmbedded() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isEmbedded();
    }

    public PersistentPropertyPathExtension getParentPath() {
        if (this.path == null) {
            throw new IllegalStateException("The parent path of a root path is not defined.");
        }
        if (this.path.getLength() == 1) {
            return new PersistentPropertyPathExtension(this.context, this.entity);
        }
        return new PersistentPropertyPathExtension(this.context, (PersistentPropertyPath<RelationalPersistentProperty>)this.path.getParentPath());
    }

    public boolean isMultiValued() {
        return this.path != null && (((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isCollectionLike() || ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isQualified() || this.getParentPath().isMultiValued());
    }

    @Nullable
    public RelationalPersistentEntity<?> getLeafEntity() {
        return this.path == null ? this.entity : (RelationalPersistentEntity)this.context.getPersistentEntity(((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getActualType());
    }

    public boolean isEntity() {
        return this.path == null || ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isEntity();
    }

    public boolean isQualified() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isQualified();
    }

    public boolean isCollectionLike() {
        return this.path != null && ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).isCollectionLike();
    }

    public String getReverseColumnName() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Empty paths don't have a reverse column name");
        return ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getReverseColumnName(this);
    }

    public String getReverseColumnNameAlias() {
        return this.prefixWithTableAlias(this.getReverseColumnName());
    }

    public String getColumnName() {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        return this.assembleColumnName(((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getColumnName());
    }

    public String getColumnAlias() {
        return this.prefixWithTableAlias(this.getColumnName());
    }

    public boolean hasIdProperty() {
        RelationalPersistentEntity<?> leafEntity = this.getLeafEntity();
        return leafEntity != null && leafEntity.hasIdProperty();
    }

    public PersistentPropertyPathExtension getIdDefiningParentPath() {
        PersistentPropertyPathExtension parent = this.getParentPath();
        if (parent.path == null) {
            return parent;
        }
        if (!parent.hasIdProperty()) {
            return parent.getIdDefiningParentPath();
        }
        return parent;
    }

    public String getTableName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getTableName();
    }

    @Nullable
    public String getTableAlias() {
        PersistentPropertyPathExtension tableOwner = this.getTableOwningAncestor();
        return tableOwner.path == null ? null : tableOwner.assembleTableAlias();
    }

    public String getIdColumnName() {
        return this.getTableOwningAncestor().getRequiredLeafEntity().getIdColumn();
    }

    public String getEffectiveIdColumnName() {
        PersistentPropertyPathExtension owner = this.getTableOwningAncestor();
        return owner.path == null ? owner.getRequiredLeafEntity().getIdColumn() : owner.getReverseColumnName();
    }

    public int getLength() {
        return this.path == null ? 0 : this.path.getLength();
    }

    private PersistentPropertyPathExtension getTableOwningAncestor() {
        return this.isEntity() && !this.isEmbedded() ? this : this.getParentPath().getTableOwningAncestor();
    }

    private String assembleTableAlias() {
        String prefix;
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        RelationalPersistentProperty leafProperty = (RelationalPersistentProperty)this.path.getRequiredLeafProperty();
        String string = prefix = this.isEmbedded() ? leafProperty.getEmbeddedPrefix() : leafProperty.getName();
        if (this.path.getLength() == 1) {
            Assert.notNull((Object)prefix, (String)"Prefix mus not be null.");
            return prefix;
        }
        PersistentPropertyPathExtension parentPath = this.getParentPath();
        return parentPath.isEmbedded() ? parentPath.assembleTableAlias() + prefix : parentPath.assembleTableAlias() + "_" + prefix;
    }

    private String assembleColumnName(String suffix) {
        Assert.state((this.path != null ? 1 : 0) != 0, (String)"Path is null");
        if (this.path.getLength() <= 1) {
            return suffix;
        }
        PersistentPropertyPath parentPath = this.path.getParentPath();
        RelationalPersistentProperty parentLeaf = (RelationalPersistentProperty)parentPath.getRequiredLeafProperty();
        if (!parentLeaf.isEmbedded()) {
            return suffix;
        }
        String embeddedPrefix = parentLeaf.getEmbeddedPrefix();
        return this.getParentPath().assembleColumnName(embeddedPrefix + suffix);
    }

    private RelationalPersistentEntity<?> getRequiredLeafEntity() {
        return this.path == null ? this.entity : (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getActualType());
    }

    private String prefixWithTableAlias(String columnName) {
        String tableAlias = this.getTableAlias();
        return tableAlias == null ? columnName : tableAlias + "_" + columnName;
    }

    public boolean matches(PersistentPropertyPath<RelationalPersistentProperty> path) {
        return this.path == null ? path.isEmpty() : this.path.equals(path);
    }

    public RelationalPersistentProperty getRequiredIdProperty() {
        return this.path == null ? (RelationalPersistentProperty)this.entity.getRequiredIdProperty() : (RelationalPersistentProperty)this.getLeafEntity().getRequiredIdProperty();
    }

    public String getKeyColumn() {
        return this.path == null ? "" : ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getKeyColumn();
    }

    public Class<?> getQualifierColumnType() {
        return this.path == null ? null : ((RelationalPersistentProperty)this.path.getRequiredLeafProperty()).getQualifierColumnType();
    }

    public PersistentPropertyPathExtension extendBy(RelationalPersistentProperty property) {
        PersistentPropertyPath newPath = this.path == null ? this.context.getPersistentPropertyPath(property.getName(), this.entity.getType()) : this.context.getPersistentPropertyPath(this.path.toDotPath() + "." + property.getName(), this.entity.getType());
        return new PersistentPropertyPathExtension(this.context, (PersistentPropertyPath<RelationalPersistentProperty>)newPath);
    }

    public String toString() {
        return String.format("PersistentPropertyPathExtension[%s, %s]", this.entity.getName(), this.path == null ? "-" : this.path.toDotPath());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersistentPropertyPathExtension)) {
            return false;
        }
        PersistentPropertyPathExtension other = (PersistentPropertyPathExtension)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RelationalPersistentEntity<?> this$entity = this.entity;
        RelationalPersistentEntity<?> other$entity = other.entity;
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
            return false;
        }
        PersistentPropertyPath<RelationalPersistentProperty> this$path = this.path;
        PersistentPropertyPath<RelationalPersistentProperty> other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> this$context = this.context;
        MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> other$context = other.context;
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersistentPropertyPathExtension;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RelationalPersistentEntity<?> $entity = this.entity;
        result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
        PersistentPropertyPath<RelationalPersistentProperty> $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        MappingContext<RelationalPersistentEntity<?>, RelationalPersistentProperty> $context = this.context;
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }
}

