/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BasicClassIntrospector;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.util.Assert;

class WrappedProperties {
    private static final ClassIntrospector INTROSPECTOR = new BasicClassIntrospector();
    private static final AnnotationIntrospector ANNOTATION_INTROSPECTOR = new JacksonAnnotationIntrospector();
    private final Map<String, List<PersistentProperty<?>>> fieldNameToProperties;

    private WrappedProperties(Map<String, List<PersistentProperty<?>>> fieldNameToProperties) {
        this.fieldNameToProperties = new HashMap(fieldNameToProperties);
    }

    public static WrappedProperties fromJacksonProperties(PersistentEntities persistentEntities, PersistentEntity<?, ?> entity, ObjectMapper mapper) {
        Assert.notNull(entity, (String)"PersistentEntity must not be null!");
        JacksonUnwrappedPropertiesResolver resolver = new JacksonUnwrappedPropertiesResolver(persistentEntities, mapper);
        return new WrappedProperties(resolver.findUnwrappedPropertyPaths(entity.getType()));
    }

    public boolean hasPersistentPropertiesForField(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.fieldNameToProperties.containsKey(fieldName);
    }

    public List<PersistentProperty<?>> getPersistentProperties(String fieldName) {
        Assert.hasText((String)fieldName, (String)"Field name must not be null or empty!");
        return this.hasPersistentPropertiesForField(fieldName) ? Collections.unmodifiableList(this.fieldNameToProperties.get(fieldName)) : Collections.emptyList();
    }

    static class JacksonUnwrappedPropertiesResolver {
        @NonNull
        private final PersistentEntities persistentEntities;
        @NonNull
        private final ObjectMapper mapper;

        public Map<String, List<PersistentProperty<?>>> findUnwrappedPropertyPaths(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return this.findUnwrappedPropertyPaths(type, NameTransformer.NOP, false);
        }

        private Map<String, List<PersistentProperty<?>>> findUnwrappedPropertyPaths(Class<?> type, NameTransformer nameTransformer, boolean considerRegularProperties) {
            PersistentEntity entity = this.persistentEntities.getPersistentEntity(type);
            if (entity == null) {
                return Collections.emptyMap();
            }
            HashMap mapping = new HashMap();
            for (BeanPropertyDefinition property : this.getMappedProperties(entity)) {
                AnnotatedMember annotatedMember = JacksonUnwrappedPropertiesResolver.findAnnotatedMember(property);
                PersistentProperty persistentProperty = entity.getPersistentProperty(property.getInternalName());
                if (JacksonUnwrappedPropertiesResolver.isJsonUnwrapped(annotatedMember)) {
                    mapping.putAll(this.findUnwrappedPropertyPaths(nameTransformer, annotatedMember, persistentProperty));
                    continue;
                }
                if (!considerRegularProperties) continue;
                mapping.put(nameTransformer.transform(property.getName()), Collections.singletonList(persistentProperty));
            }
            return mapping;
        }

        private Map<String, List<PersistentProperty<?>>> findUnwrappedPropertyPaths(NameTransformer nameTransformer, AnnotatedMember annotatedMember, PersistentProperty<?> persistentProperty) {
            HashMap mapping = new HashMap();
            NameTransformer propertyNameTransformer = NameTransformer.chainedTransformer((NameTransformer)nameTransformer, (NameTransformer)ANNOTATION_INTROSPECTOR.findUnwrappingNameTransformer(annotatedMember));
            Map<String, List<PersistentProperty<?>>> nestedProperties = this.findUnwrappedPropertyPaths(annotatedMember.getRawType(), propertyNameTransformer, true);
            for (Map.Entry<String, List<PersistentProperty<?>>> entry : nestedProperties.entrySet()) {
                ArrayList persistentProperties = new ArrayList();
                persistentProperties.add(persistentProperty);
                persistentProperties.addAll((Collection)entry.getValue());
                mapping.put(entry.getKey(), persistentProperties);
            }
            return mapping;
        }

        private List<BeanPropertyDefinition> getMappedProperties(PersistentEntity<?, ?> entity) {
            List properties = this.getBeanDescription(entity.getType()).findProperties();
            ArrayList<BeanPropertyDefinition> withInternalName = new ArrayList<BeanPropertyDefinition>(properties.size());
            for (BeanPropertyDefinition property : properties) {
                AnnotatedMember annotatedMember = JacksonUnwrappedPropertiesResolver.findAnnotatedMember(property);
                if (annotatedMember == null || entity.getPersistentProperty(property.getInternalName()) == null) continue;
                withInternalName.add(property);
            }
            return withInternalName;
        }

        private BeanDescription getBeanDescription(Class<?> type) {
            return INTROSPECTOR.forDeserialization(this.mapper.getDeserializationConfig(), this.mapper.constructType(type), (ClassIntrospector.MixInResolver)this.mapper.getDeserializationConfig());
        }

        private static AnnotatedMember findAnnotatedMember(BeanPropertyDefinition property) {
            if (property.getPrimaryMember() != null) {
                return property.getPrimaryMember();
            }
            if (property.getGetter() != null) {
                return property.getGetter();
            }
            if (property.getSetter() != null) {
                return property.getSetter();
            }
            return null;
        }

        private static boolean isJsonUnwrapped(AnnotatedMember primaryMember) {
            return primaryMember.hasAnnotation(JsonUnwrapped.class) && ((JsonUnwrapped)primaryMember.getAnnotation(JsonUnwrapped.class)).enabled();
        }

        public JacksonUnwrappedPropertiesResolver(@NonNull PersistentEntities persistentEntities, @NonNull ObjectMapper mapper) {
            if (persistentEntities == null) {
                throw new IllegalArgumentException("persistentEntities is null");
            }
            if (mapper == null) {
                throw new IllegalArgumentException("mapper is null");
            }
            this.persistentEntities = persistentEntities;
            this.mapper = mapper;
        }
    }
}

