/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ui.velocity;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class SpringResourceLoader
extends org.apache.velocity.runtime.resource.loader.ResourceLoader {
    public static final String NAME = "spring";
    public static final String SPRING_RESOURCE_LOADER_CLASS = "spring.resource.loader.class";
    public static final String SPRING_RESOURCE_LOADER_CACHE = "spring.resource.loader.cache";
    public static final String SPRING_RESOURCE_LOADER = "spring.resource.loader";
    public static final String SPRING_RESOURCE_LOADER_PATH = "spring.resource.loader.path";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ResourceLoader resourceLoader;
    private String[] resourceLoaderPaths;

    public void init(ExtendedProperties configuration) {
        this.resourceLoader = (ResourceLoader)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER);
        String resourceLoaderPath = (String)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER_PATH);
        if (this.resourceLoader == null) {
            throw new IllegalArgumentException("'resourceLoader' application attribute must be present for SpringResourceLoader");
        }
        if (resourceLoaderPath == null) {
            throw new IllegalArgumentException("'resourceLoaderPath' application attribute must be present for SpringResourceLoader");
        }
        this.resourceLoaderPaths = StringUtils.commaDelimitedListToStringArray((String)resourceLoaderPath);
        for (int i = 0; i < this.resourceLoaderPaths.length; ++i) {
            String path = this.resourceLoaderPaths[i];
            if (path.endsWith("/")) continue;
            this.resourceLoaderPaths[i] = path + "/";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("SpringResourceLoader for Velocity: using resource loader [" + this.resourceLoader + "] and resource loader paths " + Arrays.asList(this.resourceLoaderPaths)));
        }
    }

    public InputStream getResourceStream(String source) throws ResourceNotFoundException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking for Velocity resource with name [" + source + "]"));
        }
        for (String resourceLoaderPath : this.resourceLoaderPaths) {
            org.springframework.core.io.Resource resource = this.resourceLoader.getResource(resourceLoaderPath + source);
            try {
                return resource.getInputStream();
            }
            catch (IOException ex) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug((Object)("Could not find Velocity resource: " + resource));
            }
        }
        throw new ResourceNotFoundException("Could not find resource [" + source + "] in Spring resource loader path");
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

