/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.web.reactive.server;

import java.net.URI;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationContext;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.format.FormatterRegistry;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.test.web.reactive.server.ApplicationContextSpec;
import org.springframework.test.web.reactive.server.DefaultControllerSpec;
import org.springframework.test.web.reactive.server.DefaultMockServerSpec;
import org.springframework.test.web.reactive.server.DefaultRouterFunctionSpec;
import org.springframework.test.web.reactive.server.DefaultWebTestClientBuilder;
import org.springframework.test.web.reactive.server.EntityExchangeResult;
import org.springframework.test.web.reactive.server.FluxExchangeResult;
import org.springframework.test.web.reactive.server.HeaderAssertions;
import org.springframework.test.web.reactive.server.JsonPathAssertions;
import org.springframework.test.web.reactive.server.MockServerConfigurer;
import org.springframework.test.web.reactive.server.StatusAssertions;
import org.springframework.test.web.reactive.server.WebTestClientConfigurer;
import org.springframework.util.MultiValueMap;
import org.springframework.validation.Validator;
import org.springframework.web.reactive.accept.RequestedContentTypeResolverBuilder;
import org.springframework.web.reactive.config.CorsRegistry;
import org.springframework.web.reactive.config.PathMatchConfigurer;
import org.springframework.web.reactive.config.ViewResolverRegistry;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.server.HandlerStrategies;
import org.springframework.web.reactive.function.server.RouterFunction;
import org.springframework.web.reactive.result.method.annotation.ArgumentResolverConfigurer;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebHandler;
import org.springframework.web.server.session.WebSessionManager;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

public interface WebTestClient {
    public static final String WEBTESTCLIENT_REQUEST_ID = "WebTestClient-Request-Id";

    public RequestHeadersUriSpec<?> get();

    public RequestHeadersUriSpec<?> head();

    public RequestBodyUriSpec post();

    public RequestBodyUriSpec put();

    public RequestBodyUriSpec patch();

    public RequestHeadersUriSpec<?> delete();

    public RequestHeadersUriSpec<?> options();

    public RequestBodyUriSpec method(HttpMethod var1);

    public Builder mutate();

    public WebTestClient mutateWith(WebTestClientConfigurer var1);

    public static ControllerSpec bindToController(Object ... controllers) {
        return new DefaultControllerSpec(controllers);
    }

    public static MockServerSpec<?> bindToApplicationContext(ApplicationContext applicationContext) {
        return new ApplicationContextSpec(applicationContext);
    }

    public static RouterFunctionSpec bindToRouterFunction(RouterFunction<?> routerFunction) {
        return new DefaultRouterFunctionSpec(routerFunction);
    }

    public static MockServerSpec<?> bindToWebHandler(WebHandler webHandler) {
        return new DefaultMockServerSpec(webHandler);
    }

    public static Builder bindToServer() {
        return new DefaultWebTestClientBuilder();
    }

    public static interface BodyContentSpec {
        public EntityExchangeResult<Void> isEmpty();

        public BodyContentSpec json(String var1);

        public JsonPathAssertions jsonPath(String var1, Object ... var2);

        public BodyContentSpec consumeWith(Consumer<EntityExchangeResult<byte[]>> var1);

        public EntityExchangeResult<byte[]> returnResult();
    }

    public static interface ListBodySpec<E>
    extends BodySpec<List<E>, ListBodySpec<E>> {
        public ListBodySpec<E> hasSize(int var1);

        public ListBodySpec<E> contains(E ... var1);

        public ListBodySpec<E> doesNotContain(E ... var1);
    }

    public static interface BodySpec<B, S extends BodySpec<B, S>> {
        public <T extends S> T isEqualTo(B var1);

        public <T extends S> T consumeWith(Consumer<EntityExchangeResult<B>> var1);

        public EntityExchangeResult<B> returnResult();
    }

    public static interface ResponseSpec {
        public StatusAssertions expectStatus();

        public HeaderAssertions expectHeader();

        public <B> BodySpec<B, ?> expectBody(Class<B> var1);

        public <B> BodySpec<B, ?> expectBody(ParameterizedTypeReference<B> var1);

        public <E> ListBodySpec<E> expectBodyList(Class<E> var1);

        public <E> ListBodySpec<E> expectBodyList(ParameterizedTypeReference<E> var1);

        public BodyContentSpec expectBody();

        public <T> FluxExchangeResult<T> returnResult(Class<T> var1);

        public <T> FluxExchangeResult<T> returnResult(ParameterizedTypeReference<T> var1);
    }

    public static interface RequestBodyUriSpec
    extends RequestBodySpec,
    RequestHeadersUriSpec<RequestBodySpec> {
    }

    public static interface RequestHeadersUriSpec<S extends RequestHeadersSpec<S>>
    extends UriSpec<S>,
    RequestHeadersSpec<S> {
    }

    public static interface RequestBodySpec
    extends RequestHeadersSpec<RequestBodySpec> {
        public RequestBodySpec contentLength(long var1);

        public RequestBodySpec contentType(MediaType var1);

        public RequestHeadersSpec<?> body(BodyInserter<?, ? super ClientHttpRequest> var1);

        public <T, S extends Publisher<T>> RequestHeadersSpec<?> body(S var1, Class<T> var2);

        public RequestHeadersSpec<?> syncBody(Object var1);
    }

    public static interface RequestHeadersSpec<S extends RequestHeadersSpec<S>> {
        public S accept(MediaType ... var1);

        public S acceptCharset(Charset ... var1);

        public S cookie(String var1, String var2);

        public S cookies(Consumer<MultiValueMap<String, String>> var1);

        public S ifModifiedSince(ZonedDateTime var1);

        public S ifNoneMatch(String ... var1);

        public S header(String var1, String ... var2);

        public S headers(Consumer<HttpHeaders> var1);

        public S attribute(String var1, Object var2);

        public S attributes(Consumer<Map<String, Object>> var1);

        public ResponseSpec exchange();
    }

    public static interface UriSpec<S extends RequestHeadersSpec<?>> {
        public S uri(URI var1);

        public S uri(String var1, Object ... var2);

        public S uri(String var1, Map<String, ?> var2);

        public S uri(Function<UriBuilder, URI> var1);
    }

    public static interface Builder {
        public Builder baseUrl(String var1);

        public Builder uriBuilderFactory(UriBuilderFactory var1);

        public Builder defaultHeader(String var1, String ... var2);

        public Builder defaultHeaders(Consumer<HttpHeaders> var1);

        public Builder defaultCookie(String var1, String ... var2);

        public Builder defaultCookies(Consumer<MultiValueMap<String, String>> var1);

        public Builder filter(ExchangeFilterFunction var1);

        public Builder filters(Consumer<List<ExchangeFilterFunction>> var1);

        public Builder exchangeStrategies(ExchangeStrategies var1);

        public Builder responseTimeout(Duration var1);

        public Builder apply(WebTestClientConfigurer var1);

        public WebTestClient build();
    }

    public static interface RouterFunctionSpec
    extends MockServerSpec<RouterFunctionSpec> {
        public RouterFunctionSpec handlerStrategies(HandlerStrategies var1);
    }

    public static interface ControllerSpec
    extends MockServerSpec<ControllerSpec> {
        public ControllerSpec controllerAdvice(Object ... var1);

        public ControllerSpec contentTypeResolver(Consumer<RequestedContentTypeResolverBuilder> var1);

        public ControllerSpec corsMappings(Consumer<CorsRegistry> var1);

        public ControllerSpec pathMatching(Consumer<PathMatchConfigurer> var1);

        public ControllerSpec argumentResolvers(Consumer<ArgumentResolverConfigurer> var1);

        public ControllerSpec httpMessageCodecs(Consumer<ServerCodecConfigurer> var1);

        public ControllerSpec formatters(Consumer<FormatterRegistry> var1);

        public ControllerSpec validator(Validator var1);

        public ControllerSpec viewResolvers(Consumer<ViewResolverRegistry> var1);
    }

    public static interface MockServerSpec<B extends MockServerSpec<B>> {
        public <T extends B> T webFilter(WebFilter ... var1);

        public <T extends B> T webSessionManager(WebSessionManager var1);

        public <T extends B> T apply(MockServerConfigurer var1);

        public Builder configureClient();

        public WebTestClient build();
    }
}

