/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.support;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePropertySource;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.support.MergedTestPropertySources;
import org.springframework.test.context.support.TestPropertySourceAttributes;
import org.springframework.test.context.util.TestContextResourceUtils;
import org.springframework.test.util.MetaAnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class TestPropertySourceUtils {
    public static final String INLINED_PROPERTIES_PROPERTY_SOURCE_NAME = "Inlined Test Properties";
    private static final Log logger = LogFactory.getLog(TestPropertySourceUtils.class);

    static MergedTestPropertySources buildMergedTestPropertySources(Class<?> testClass) {
        Class<TestPropertySource> annotationType = TestPropertySource.class;
        MetaAnnotationUtils.AnnotationDescriptor<TestPropertySource> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        if (descriptor == null) {
            return new MergedTestPropertySources();
        }
        List<TestPropertySourceAttributes> attributesList = TestPropertySourceUtils.resolveTestPropertySourceAttributes(testClass);
        String[] locations = TestPropertySourceUtils.mergeLocations(attributesList);
        String[] properties = TestPropertySourceUtils.mergeProperties(attributesList);
        return new MergedTestPropertySources(locations, properties);
    }

    private static List<TestPropertySourceAttributes> resolveTestPropertySourceAttributes(Class<?> testClass) {
        Assert.notNull(testClass, (String)"Class must not be null");
        ArrayList<TestPropertySourceAttributes> attributesList = new ArrayList<TestPropertySourceAttributes>();
        Class<TestPropertySource> annotationType = TestPropertySource.class;
        MetaAnnotationUtils.AnnotationDescriptor<TestPropertySource> descriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, annotationType);
        Assert.notNull(descriptor, (String)String.format("Could not find an 'annotation declaring class' for annotation type [%s] and class [%s]", annotationType.getName(), testClass.getName()));
        while (descriptor != null) {
            TestPropertySource testPropertySource = descriptor.synthesizeAnnotation();
            Class<?> rootDeclaringClass = descriptor.getRootDeclaringClass();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Retrieved @TestPropertySource [%s] for declaring class [%s].", testPropertySource, rootDeclaringClass.getName()));
            }
            TestPropertySourceAttributes attributes = new TestPropertySourceAttributes(rootDeclaringClass, testPropertySource);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Resolved TestPropertySource attributes: " + attributes));
            }
            attributesList.add(attributes);
            descriptor = MetaAnnotationUtils.findAnnotationDescriptor(rootDeclaringClass.getSuperclass(), annotationType);
        }
        return attributesList;
    }

    private static String[] mergeLocations(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> locations = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing locations for TestPropertySource attributes %s", attrs));
            }
            String[] locationsArray = TestContextResourceUtils.convertToClasspathResourcePaths(attrs.getDeclaringClass(), attrs.getLocations());
            locations.addAll(0, Arrays.asList(locationsArray));
            if (attrs.isInheritLocations()) continue;
            break;
        }
        return StringUtils.toStringArray(locations);
    }

    private static String[] mergeProperties(List<TestPropertySourceAttributes> attributesList) {
        ArrayList<String> properties = new ArrayList<String>();
        for (TestPropertySourceAttributes attrs : attributesList) {
            String[] attrProps;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)String.format("Processing inlined properties for TestPropertySource attributes %s", attrs));
            }
            if ((attrProps = attrs.getProperties()) != null) {
                properties.addAll(0, Arrays.asList(attrProps));
            }
            if (attrs.isInheritProperties()) continue;
            break;
        }
        return StringUtils.toStringArray(properties);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableApplicationContext context, String ... locations) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        Assert.notNull((Object)locations, (String)"'locations' must not be null");
        TestPropertySourceUtils.addPropertiesFilesToEnvironment(context.getEnvironment(), (ResourceLoader)context, locations);
    }

    public static void addPropertiesFilesToEnvironment(ConfigurableEnvironment environment, ResourceLoader resourceLoader, String ... locations) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        Assert.notNull((Object)resourceLoader, (String)"'resourceLoader' must not be null");
        Assert.notNull((Object)locations, (String)"'locations' must not be null");
        try {
            for (String location : locations) {
                String resolvedLocation = environment.resolveRequiredPlaceholders(location);
                Resource resource = resourceLoader.getResource(resolvedLocation);
                environment.getPropertySources().addFirst((PropertySource)new ResourcePropertySource(resource));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to add PropertySource to Environment", ex);
        }
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableApplicationContext context, String ... inlinedProperties) {
        Assert.notNull((Object)context, (String)"'context' must not be null");
        Assert.notNull((Object)inlinedProperties, (String)"'inlinedProperties' must not be null");
        TestPropertySourceUtils.addInlinedPropertiesToEnvironment(context.getEnvironment(), inlinedProperties);
    }

    public static void addInlinedPropertiesToEnvironment(ConfigurableEnvironment environment, String ... inlinedProperties) {
        Assert.notNull((Object)environment, (String)"'environment' must not be null");
        Assert.notNull((Object)inlinedProperties, (String)"'inlinedProperties' must not be null");
        if (!ObjectUtils.isEmpty((Object[])inlinedProperties)) {
            MapPropertySource ps;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding inlined properties to environment: " + ObjectUtils.nullSafeToString((Object[])inlinedProperties)));
            }
            if ((ps = (MapPropertySource)environment.getPropertySources().get(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME)) == null) {
                ps = new MapPropertySource(INLINED_PROPERTIES_PROPERTY_SOURCE_NAME, new LinkedHashMap());
                environment.getPropertySources().addFirst((PropertySource)ps);
            }
            ((Map)ps.getSource()).putAll(TestPropertySourceUtils.convertInlinedPropertiesToMap(inlinedProperties));
        }
    }

    public static Map<String, Object> convertInlinedPropertiesToMap(String ... inlinedProperties) {
        Assert.notNull((Object)inlinedProperties, (String)"'inlinedProperties' must not be null");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Properties props = new Properties();
        for (String pair : inlinedProperties) {
            if (!StringUtils.hasText((String)pair)) continue;
            try {
                props.load(new StringReader(pair));
            }
            catch (Exception ex) {
                throw new IllegalStateException("Failed to load test environment property from [" + pair + "]", ex);
            }
            Assert.state((props.size() == 1 ? 1 : 0) != 0, () -> "Failed to load exactly one test environment property from [" + pair + "]");
            for (String name : props.stringPropertyNames()) {
                map.put(name, props.getProperty(name));
            }
            props.clear();
        }
        return map;
    }
}

