/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.function.client;

import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.DefaultClientResponse;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import reactor.core.publisher.Flux;

class DefaultClientResponseBuilder
implements ClientResponse.Builder {
    private final HttpHeaders headers = new HttpHeaders();
    private final MultiValueMap<String, ResponseCookie> cookies = new LinkedMultiValueMap();
    private HttpStatus statusCode = HttpStatus.OK;
    private Flux<DataBuffer> body = Flux.empty();
    private ExchangeStrategies strategies;

    public DefaultClientResponseBuilder(ExchangeStrategies strategies) {
        Assert.notNull((Object)strategies, (String)"'strategies' must not be null");
        this.strategies = strategies;
    }

    public DefaultClientResponseBuilder(ClientResponse other) {
        this(other.strategies());
        this.statusCode(other.statusCode());
        this.headers(headers2 -> headers2.addAll((MultiValueMap)other.headers().asHttpHeaders()));
        this.cookies(cookies -> cookies.addAll(other.cookies()));
    }

    @Override
    public DefaultClientResponseBuilder statusCode(HttpStatus statusCode) {
        Assert.notNull((Object)statusCode, (String)"'statusCode' must not be null");
        this.statusCode = statusCode;
        return this;
    }

    @Override
    public ClientResponse.Builder header(String headerName, String ... headerValues) {
        for (String headerValue : headerValues) {
            this.headers.add(headerName, headerValue);
        }
        return this;
    }

    @Override
    public ClientResponse.Builder headers(Consumer<HttpHeaders> headersConsumer) {
        Assert.notNull(headersConsumer, (String)"'headersConsumer' must not be null");
        headersConsumer.accept(this.headers);
        return this;
    }

    @Override
    public DefaultClientResponseBuilder cookie(String name, String ... values) {
        for (String value : values) {
            this.cookies.add((Object)name, (Object)ResponseCookie.from((String)name, (String)value).build());
        }
        return this;
    }

    @Override
    public ClientResponse.Builder cookies(Consumer<MultiValueMap<String, ResponseCookie>> cookiesConsumer) {
        Assert.notNull(cookiesConsumer, (String)"'cookiesConsumer' must not be null");
        cookiesConsumer.accept(this.cookies);
        return this;
    }

    @Override
    public ClientResponse.Builder body(Flux<DataBuffer> body2) {
        Assert.notNull(body2, (String)"'body' must not be null");
        this.releaseBody();
        this.body = body2;
        return this;
    }

    @Override
    public ClientResponse.Builder body(String body2) {
        Assert.notNull((Object)body2, (String)"'body' must not be null");
        this.releaseBody();
        DefaultDataBufferFactory dataBufferFactory = new DefaultDataBufferFactory();
        this.body = Flux.just((Object)body2).map(arg_0 -> DefaultClientResponseBuilder.lambda$body$2(body2, (DataBufferFactory)dataBufferFactory, arg_0));
        return this;
    }

    private void releaseBody() {
        this.body.subscribe(DataBufferUtils.releaseConsumer());
    }

    @Override
    public ClientResponse build() {
        BuiltClientHttpResponse clientHttpResponse = new BuiltClientHttpResponse(this.statusCode, this.headers, this.cookies, this.body);
        return new DefaultClientResponse(clientHttpResponse, this.strategies);
    }

    private static /* synthetic */ DataBuffer lambda$body$2(String body2, DataBufferFactory dataBufferFactory, String s) {
        byte[] bytes = body2.getBytes(StandardCharsets.UTF_8);
        return dataBufferFactory.wrap(bytes);
    }

    private static class BuiltClientHttpResponse
    implements ClientHttpResponse {
        private final HttpStatus statusCode;
        private final HttpHeaders headers;
        private final MultiValueMap<String, ResponseCookie> cookies;
        private final Flux<DataBuffer> body;

        public BuiltClientHttpResponse(HttpStatus statusCode, HttpHeaders headers2, MultiValueMap<String, ResponseCookie> cookies, Flux<DataBuffer> body2) {
            this.statusCode = statusCode;
            this.headers = HttpHeaders.readOnlyHttpHeaders((HttpHeaders)headers2);
            this.cookies = BuiltClientHttpResponse.unmodifiableCopy(cookies);
            this.body = body2;
        }

        @Nullable
        private static <K, V> MultiValueMap<K, V> unmodifiableCopy(@Nullable MultiValueMap<K, V> original) {
            if (original != null) {
                return CollectionUtils.unmodifiableMultiValueMap((MultiValueMap)new LinkedMultiValueMap(original));
            }
            return null;
        }

        public HttpStatus getStatusCode() {
            return this.statusCode;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }

        public MultiValueMap<String, ResponseCookie> getCookies() {
            return this.cookies;
        }

        public Flux<DataBuffer> getBody() {
            return this.body;
        }
    }
}

