/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method.annotation;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.ui.Model;
import org.springframework.web.reactive.BindingContext;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolverSupport;
import org.springframework.web.reactive.result.method.SyncHandlerMethodArgumentResolver;
import org.springframework.web.server.ServerWebExchange;

public class ModelArgumentResolver
extends HandlerMethodArgumentResolverSupport
implements SyncHandlerMethodArgumentResolver {
    public ModelArgumentResolver(ReactiveAdapterRegistry adapterRegistry) {
        super(adapterRegistry);
    }

    @Override
    public boolean supportsParameter(MethodParameter param) {
        return this.checkParameterTypeNoReactiveWrapper(param, type -> Model.class.isAssignableFrom((Class<?>)type) || Map.class.isAssignableFrom((Class<?>)type) && param.getParameterAnnotations().length == 0);
    }

    @Override
    public Object resolveArgumentValue(MethodParameter parameter, BindingContext context, ServerWebExchange exchange) {
        Class type = parameter.getParameterType();
        if (Model.class.isAssignableFrom(type)) {
            return context.getModel();
        }
        if (Map.class.isAssignableFrom(type)) {
            return context.getModel().asMap();
        }
        throw new IllegalStateException("Unexpected method parameter type: " + type);
    }
}

