/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.asm;

import com.springsource.bundlor.support.asm.ArtefactAnalyserFieldVisitor;
import com.springsource.bundlor.support.asm.ArtefactAnalyserMethodVisitor;
import com.springsource.bundlor.support.asm.VisitorUtils;
import com.springsource.bundlor.support.partialmanifest.PartialManifest;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

final class ArtefactAnalyserClassVisitor
extends EmptyVisitor
implements ClassVisitor {
    private static final String CLASS_NAME_PREFIX = "class$";
    private final PartialManifest partialManifest;
    private Type type;

    public ArtefactAnalyserClassVisitor(PartialManifest partialManifest) {
        this.partialManifest = partialManifest;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        Type type;
        this.type = type = Type.getObjectType((String)name);
        this.partialManifest.recordType(VisitorUtils.getFullyQualifiedTypeName(type));
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getObjectType((String)superName));
        VisitorUtils.recordUses(this.partialManifest, type, Type.getObjectType((String)superName));
        String[] stringArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            String interfaceName = stringArray[n2];
            VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getObjectType((String)interfaceName));
            VisitorUtils.recordUses(this.partialManifest, type, Type.getObjectType((String)interfaceName));
            ++n2;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        Type t = Type.getType((String)desc);
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
        VisitorUtils.recordUses(this.partialManifest, this.type, t);
        return null;
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Type t = Type.getType((String)desc);
        if ((access & 0x1000) == 4096 && Class.class.getName().equals(t.getClassName()) && name != null && name.startsWith(CLASS_NAME_PREFIX)) {
            name = name.substring(CLASS_NAME_PREFIX.length());
            name = name.replace('$', '.');
            int lastDotIndex = name.lastIndexOf(46);
            int i = 0;
            while (i < lastDotIndex) {
                if (Character.isUpperCase(name.charAt(i))) {
                    if (i == 0) {
                        return null;
                    }
                    if (name.charAt(i - 1) == '.') {
                        name = String.valueOf(name.substring(0, i)) + name.substring(i).replace('.', '$');
                        break;
                    }
                }
                ++i;
            }
            if (Character.isJavaIdentifierStart(name.charAt(0))) {
                this.partialManifest.recordReferencedType(name);
            }
        }
        VisitorUtils.recordReferencedTypes(this.partialManifest, t);
        return new ArtefactAnalyserFieldVisitor(this.partialManifest, this.type);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        String exception;
        int n;
        int n2;
        String[] stringArray;
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getArgumentTypes((String)desc));
        VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getReturnType((String)desc));
        if (exceptions != null) {
            stringArray = exceptions;
            n2 = exceptions.length;
            n = 0;
            while (n < n2) {
                exception = stringArray[n];
                VisitorUtils.recordReferencedTypes(this.partialManifest, Type.getObjectType((String)exception));
                ++n;
            }
        }
        if (access != 2) {
            VisitorUtils.recordUses(this.partialManifest, this.type, Type.getArgumentTypes((String)desc));
            VisitorUtils.recordUses(this.partialManifest, this.type, Type.getReturnType((String)desc));
            if (exceptions != null) {
                stringArray = exceptions;
                n2 = exceptions.length;
                n = 0;
                while (n < n2) {
                    exception = stringArray[n];
                    VisitorUtils.recordUses(this.partialManifest, this.type, Type.getObjectType((String)exception));
                    ++n;
                }
            }
        }
        return new ArtefactAnalyserMethodVisitor(this.partialManifest, this.type);
    }
}

