/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.manifestwriter;

import com.springsource.bundlor.ManifestWriter;
import com.springsource.bundlor.util.BundleManifestUtils;
import com.springsource.util.parser.manifest.ManifestContents;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

final class FileSystemManifestWriter
implements ManifestWriter {
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private final File manifestFile;

    public FileSystemManifestWriter(File root) {
        this.manifestFile = new File(root, MANIFEST_PATH);
    }

    public void write(ManifestContents manifest) {
        Writer out = null;
        try {
            try {
                if (!this.manifestFile.getParentFile().exists() && !this.manifestFile.getParentFile().mkdirs()) {
                    throw new RuntimeException(String.format("Could not create parent directories of '%s'", this.manifestFile.getAbsolutePath()));
                }
                out = new FileWriter(this.manifestFile);
                BundleManifestUtils.createBundleManifest(manifest).write(out);
                System.out.printf("Manifest written to '%s'%n", this.manifestFile.getAbsolutePath());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void close() {
    }
}

