/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.common;

import com.springsource.util.common.SynchronizedIterator;
import com.springsource.util.common.SynchronizedObject;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizedCollection<T>
extends SynchronizedObject
implements Collection<T> {
    private final Collection<T> collection;
    private final Object monitor;
    private static final Object tieMonitor = new Object();

    public SynchronizedCollection(Collection<? extends T> collection, Object monitor) {
        super(collection, monitor);
        this.collection = collection;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int result = 1;
        Object object = this.monitor;
        synchronized (object) {
            result = 31 * result + this.collection.hashCode();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object obj) {
        int otherHash;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynchronizedCollection other = (SynchronizedCollection)obj;
        int thisHash = System.identityHashCode(this);
        if (thisHash < (otherHash = System.identityHashCode(other))) {
            Object object = this.monitor;
            synchronized (object) {
                Object object2 = other.monitor;
                synchronized (object2) {
                    if (this.collection.equals(other.collection)) return true;
                    return false;
                }
            }
        }
        if (thisHash > otherHash) {
            Object object = other.monitor;
            synchronized (object) {
                Object object3 = this.monitor;
                synchronized (object3) {
                    if (this.collection.equals(other.collection)) return true;
                    return false;
                }
            }
        }
        Object object = tieMonitor;
        synchronized (object) {
            Object object4 = this.monitor;
            synchronized (object4) {
                Object object5 = other.monitor;
                synchronized (object5) {
                    if (this.collection.equals(other.collection)) return true;
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T e) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> c) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.monitor;
        synchronized (object) {
            this.collection.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        Object object = this.monitor;
        synchronized (object) {
            return new SynchronizedIterator<T>(this.collection.iterator(), this.monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <U> U[] toArray(U[] a) {
        Object object = this.monitor;
        synchronized (object) {
            return this.collection.toArray(a);
        }
    }
}

