/*
 * Decompiled with CFR 0.152.
 */
package gui.ava.html.link;

import gui.ava.html.link.LinkInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;

public class LinkHarvester {
    private final JTextComponent textComponent;
    private final List<LinkInfo> links = new ArrayList<LinkInfo>();

    public LinkHarvester(JEditorPane textComponent) {
        this.textComponent = textComponent;
        this.harvestElement(textComponent.getDocument().getDefaultRootElement());
    }

    public List<LinkInfo> getLinks() {
        return this.links;
    }

    private void harvestElement(Element element) {
        if (element == null) {
            return;
        }
        AttributeSet attributes = element.getAttributes();
        Enumeration<?> attributeNames = attributes.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            Object key = attributeNames.nextElement();
            if (!HTML.Tag.A.equals(key)) continue;
            Map<String, String> linkAttributes = this.harvestAttributes(element);
            List<Rectangle> bounds = this.harvestBounds(element);
            if (linkAttributes.isEmpty() || bounds.isEmpty()) continue;
            this.links.add(new LinkInfo(linkAttributes, bounds));
        }
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element child = element.getElement(i);
            this.harvestElement(child);
        }
    }

    private Map<String, String> harvestAttributes(Element element) {
        Object value = element.getAttributes().getAttribute(HTML.Tag.A);
        if (value instanceof SimpleAttributeSet) {
            SimpleAttributeSet attributeSet = (SimpleAttributeSet)value;
            HashMap<String, String> result = new HashMap<String, String>();
            this.addAttribute(attributeSet, result, HTML.Attribute.HREF);
            this.addAttribute(attributeSet, result, HTML.Attribute.TARGET);
            this.addAttribute(attributeSet, result, HTML.Attribute.TITLE);
            this.addAttribute(attributeSet, result, HTML.Attribute.CLASS);
            this.addAttribute(attributeSet, result, "tabindex");
            this.addAttribute(attributeSet, result, "dir");
            this.addAttribute(attributeSet, result, "lang");
            this.addAttribute(attributeSet, result, "accesskey");
            this.addAttribute(attributeSet, result, "onblur");
            this.addAttribute(attributeSet, result, "onclick");
            this.addAttribute(attributeSet, result, "ondblclick");
            this.addAttribute(attributeSet, result, "onfocus");
            this.addAttribute(attributeSet, result, "onmousedown");
            this.addAttribute(attributeSet, result, "onmousemove");
            this.addAttribute(attributeSet, result, "onmouseout");
            this.addAttribute(attributeSet, result, "onmouseover");
            this.addAttribute(attributeSet, result, "onmouseup");
            this.addAttribute(attributeSet, result, "onkeydown");
            this.addAttribute(attributeSet, result, "onkeypress");
            this.addAttribute(attributeSet, result, "onkeyup");
            return result;
        }
        return Collections.emptyMap();
    }

    private void addAttribute(SimpleAttributeSet attributeSet, Map<String, String> result, Object attribute) {
        String attName = attribute.toString();
        String attValue = (String)attributeSet.getAttribute(attribute);
        if (attValue != null && !attValue.equals("")) {
            result.put(attName, attValue);
        }
    }

    private List<Rectangle> harvestBounds(Element element) {
        ArrayList<Rectangle> boundsList = new ArrayList<Rectangle>();
        try {
            int startOffset = element.getStartOffset();
            int endOffset = element.getEndOffset();
            Rectangle lastBounds = null;
            for (int i = startOffset; i <= endOffset; ++i) {
                Rectangle bounds = this.textComponent.modelToView(i);
                if (bounds == null) continue;
                if (lastBounds == null) {
                    lastBounds = bounds;
                    continue;
                }
                if (bounds.getY() == lastBounds.getY()) {
                    lastBounds = lastBounds.union(bounds);
                    continue;
                }
                if (lastBounds.getWidth() > 1.0 && lastBounds.getHeight() > 1.0) {
                    boundsList.add(lastBounds);
                }
                lastBounds = null;
            }
            if (lastBounds != null && lastBounds.getWidth() > 1.0 && lastBounds.getHeight() > 1.0) {
                boundsList.add(lastBounds);
            }
            return boundsList;
        }
        catch (BadLocationException e) {
            throw new RuntimeException("Got BadLocationException", e);
        }
    }
}

